#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.41
visibility:           public
id:                   hledger-lib-1.41-ExAuO7uzvPnF2aceiPBu6a
key:                  hledger-lib-1.41-ExAuO7uzvPnF2aceiPBu6a
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  db402abba332a9bf2f525dd6a7a763d0
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.Lucid Hledger.Write.Ods
    Hledger.Write.Spreadsheet Text.Tabular.AsciiWide Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.41-ExAuO7uzvPnF2aceiPBu6a
depends:
    Decimal-0.5.2-Hia0mmQucZx6aJcdpX4shm
    Glob-0.10.2-Bt4oTbZz6QbFLk1HGZszR8
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4
    aeson-pretty-0.8.10-6nxfz7a4luE95UqAi5t8dP
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4 array-0.5.4.0
    base-4.17.2.1 base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    blaze-html-0.9.2.0-5UHR2rFfuO85rrjBAwZQF8
    blaze-markup-0.8.3.0-Hf0qvHn7apcGFSqpkksMWB bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.4.1-8r492bYlKNjDW3rnabaOuW
    cassava-megaparsec-2.1.1-2hsux2BTcaAJirdqe5GDJS
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-2wv2ltb9NHWFgnG7RawbOn containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-B8MPDYsSTF8DV7T8R3DWXJ
    extra-1.7.16-78p7g4t2O5F2wUG9XuP5u
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    hashtables-1.4.2-KDmIF0MnrHQ45h5HQpcHX2
    lucid-2.11.20250303-76UY4kdKhyb4Gsm3EX7Q1b
    megaparsec-9.7.0-3LvenIwsMr98PPayp8iMYY
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-3HNn5XiXTTKImfyRxLqC2U process-1.6.18.0
    regex-tdfa-1.3.2.4-EAViH0SVePPGm2eZt2I5vM
    safe-0.3.21-ByjvVtJLwt5KrRntZowDKh
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-9b9FHG8OBttDZ68785yCzt
    tasty-hunit-0.10.2-CBvXc2jt1CTFB9a5803ID3 template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

