#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.43.1
visibility:           public
id:                   hledger-lib-1.43.1-GqY3fEIZqs88qi3NJUsGDp
key:                  hledger-lib-1.43.1-GqY3fEIZqs88qi3NJUsGDp
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  60cd9c788502de7d1b137f6a15f03758
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.43.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.43.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.43.1-GqY3fEIZqs88qi3NJUsGDp
depends:
    Decimal-0.5.2-8Xz4GSRjZx8Gd79OL6YTq6
    Glob-0.10.2-FyRnsoEDwFZ1HYINwLPWSe
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    aeson-pretty-0.8.10-ITwPk3erfDKFyzIgWHz5Ul
    ansi-terminal-1.0.2-BPjCUZulbk02l8COiFLYJh array-0.5.6.0
    base-4.18.2.1 blaze-html-0.9.2.0-8CIOWujpLcd2fSwCqkXFhk
    blaze-markup-0.8.3.0-8CtErBAglJMDcY5YauRCvR bytestring-0.11.5.3
    call-stack-0.4.0-1lKHXCITPU8FW27H1kph6t
    cassava-0.5.4.1-KWNl5rPnZL4HqDsgurlU6b
    cassava-megaparsec-2.1.1-5kKZEg6OUmmF2kRTH9SIh8
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    colour-2.3.6-CyG1FcjFTJD81Sod2rWhsQ containers-0.6.7
    data-default-0.7.1.3-DC0AJbPUVLOH54ZbhVmf2Q deepseq-1.4.8.1
    directory-1.3.8.5 doclayout-0.5-LkhbsYDRcpNLVPNVBlwq3T
    encoding-0.10.2-GhYhTRvVbKR5yurXXndE5Q
    extra-1.7.16-LuLvmz502dy5ojSGuZdMLA
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    hashtables-1.4.2-8i8LDDObHOdAZTpXwEb3Ke
    lucid-2.11.20250303-AV5gQxqUtj21hVByFvmv8
    megaparsec-9.7.0-7dpjbIWxHj2jHxEtJpJqK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48
    pretty-simple-4.1.3.0-2gss7YVZU4ZJcT0istcDra process-1.6.19.0
    regex-tdfa-1.3.2.5-LVEu1APtYIwJMYGWcCftyg
    safe-0.3.21-J8yTbFjKPpT3oBMPyWIsQW
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-GMkrQBNnSbO8nTUvJPpxjy
    tasty-hunit-0.10.2-JByLXjlVxQsKqJ59V4GFFQ template-haskell-2.20.0.0
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    uglymemo-0.1.0.1-9CTAG7WaUP4YIMm3gIN93
    unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA
    utf8-string-1.0.2-4PcjKdTUnsVIUZCxTUoFbK

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

