#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-6uoH25QkTfE3z1hZBBQmUV
key:                  hOpenPGP-2.10.1-6uoH25QkTfE3z1hZBBQmUV
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  f8a157efc19a27d7a55e81c7e2af1ac0
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-6uoH25QkTfE3z1hZBBQmUV
depends:
    aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
    asn1-encoding-0.9.6-KI5Zdg4pdVPC8vcGnlwtjG
    attoparsec-0.14.4-K4GZo37SQ24KyCrR1RSIsH base-4.17.2.1
    base16-bytestring-1.0.2.0-2U8KlRNggLqLs1cZzvTsOg
    bifunctors-5.6.2-LX2r8mypqWoEMCvwdCtLUH binary-0.8.9.1
    binary-conduit-1.3.1-HF5xEjLgaAoA1PzH2NyRAM bytestring-0.11.5.3
    bz2-1.0.1.1-AQNzG3NpR63AsdtU8j2iyt
    conduit-1.3.6.1-EVJ10prSzIP4i22LIWcNGH
    conduit-extra-1.3.8-6X110wJXrg3AO7uiFEQyud containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-EVfNgL4G4biwIDa0J3BAW
    errors-2.3.0-HUsL6CWU08L1qyBByg8RWG
    hashable-1.4.4.0-9uPnQxUdwOnCZlD9EiHqMs
    incremental-parser-0.5.1-R5x5bmjNHMGunwvkOL092
    ixset-typed-0.5.1.0-CrMpvnxOnjvFPVq8fymtDy
    lens-5.3-LWObp7pQkqo7IU7mPMlzlm
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-KyuZLjrVkMLH56LkxlYTeb
    openpgp-asciiarmor-0.1.2-DX9PR4CvVNZBjVZ0aFQk6d
    prettyprinter-1.7.1-OSddR9QU1LKvWd60o7pju
    resourcet-1.2.6-FgkveozFgci6lXOLCU6nL
    split-0.2.5-8TDPZlIHK1VKb3LgCQDYep text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    zlib-0.7.0.0-HNsXCdLk9sG62mRngTZgti

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

