#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-FRGPL9WscMPHk1bVYjDVIM
key:                  hOpenPGP-2.10.1-FRGPL9WscMPHk1bVYjDVIM
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  8c1131f26db6067ac3e9b656d7d8e02b
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-FRGPL9WscMPHk1bVYjDVIM
depends:
    aeson-2.1.2.1-9HQxGJjc2cdAmcsURaBDXL
    asn1-encoding-0.9.6-IaJ4cacBBAx6hjSAbsXLaU
    attoparsec-0.14.4-2WnTlN46elo3llwbGCF7aS base-4.17.2.1
    base16-bytestring-1.0.2.0-xTrtAtNLYsAcMjivoMGOH
    bifunctors-5.6.2-8SKDXId5RXfJn3kOqYrjFY binary-0.8.9.1
    binary-conduit-1.3.1-9wJKb2sTSsaI0m6nGdgVLB bytestring-0.11.5.3
    bz2-1.0.1.1-IIfMGB3TnIL6rij5YI1G6Y
    conduit-1.3.6.1-5ZSsm3oucHaEmMgze2N1VX
    conduit-extra-1.3.8-EHeHJbVBqalFyMROhCo19c containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-HC9lEkZDsCOmyrn0GvZs0
    errors-2.3.0-v8i5CEsq3WEnwbNavI6x2
    hashable-1.4.4.0-Bi9h4Si3Ui62sqHmMmGfiv
    incremental-parser-0.5.1-IBvd6GvAeskELHw6XZR6Aa
    ixset-typed-0.5.1.0-1J647nAz6YvEKSOxY8v7AI
    lens-5.3-4nRD5AeUZ87C7qubjFyG6H
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-4a4fvaL8hlS8iUTVwHnYtf
    openpgp-asciiarmor-0.1.2-54FuXJVJD1lCMO2jwANRRA
    prettyprinter-1.7.1-HfOhWgFDXrQ8Fhf8BimOva
    resourcet-1.2.6-12X4IJH43sWHWk2ruODnDD
    split-0.2.5-JwWMTmXvu7fChkavPTERve text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-3czZ5Len2GTFaAkRxFZe7E
    zlib-0.7.0.0-FA6aBLxMBUm8GSDapkxrxA

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

