#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-IggNZNAT6K7FXIK4Chpk4W
key:                  hOpenPGP-2.10.1-IggNZNAT6K7FXIK4Chpk4W
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  1e1080e81f6275671cd5d54dbfbe997b
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-IggNZNAT6K7FXIK4Chpk4W
depends:
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq
    asn1-encoding-0.9.6-C8ACvP5T4qkIoYrTXHNGrL
    attoparsec-0.14.4-KCzcP2UZhdCHukFfOxO6Y base-4.17.2.1
    base16-bytestring-1.0.2.0-Frtd16GvvzH1Yy4i4T8XhB
    bifunctors-5.6.2-EYqANdX12yCJjExqUuNjSs binary-0.8.9.1
    binary-conduit-1.3.1-19RKAs5EFr4357J6NXIslY bytestring-0.11.5.3
    bz2-1.0.1.1-AHsm86u5zEtLIWVCK8rwKS
    conduit-1.3.6.1-KIgc8u8jbkN2A9El9r6mby
    conduit-extra-1.3.8-7AsukhXAhG9EP9Xj5iNAEL containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-97IS0LmRNBNBHzLNhZNWmV
    errors-2.3.0-DPfRV2zsXCPINgBxUpnRQc
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg
    incremental-parser-0.5.1-CrXK5Y6Tyg0IIgidSTD9IR
    ixset-typed-0.5.1.0-LJsamMXdwSjJiDLsYXxw5U
    lens-5.3.1-D1RUGLJD0B7IsqWvzdm040
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-Ej2S5J8Z0oCB2cTGXU0OdX
    openpgp-asciiarmor-0.1.2-2fpenKDXNzWKIN6dJqn0y5
    prettyprinter-1.7.1-Fh4Rajbxlmi9sLGTMcb6xB
    resourcet-1.2.6-I2UUpqDV6YBEHmvIRfrjlc
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    zlib-0.7.0.0-91jlV9oVAmRK4kV4PuEmaG

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

