#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-A6kHUGEXtR07kFunB99Ui7
key:                  hOpenPGP-2.10.1-A6kHUGEXtR07kFunB99Ui7
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  c5d0dfde939aad09568d28ce213c28d9
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-A6kHUGEXtR07kFunB99Ui7
depends:
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    asn1-encoding-0.9.6-5BKtJ19xQPk93jASlswvxB
    attoparsec-0.14.4-LYMz7sGPlLCLdIXUlDCVP9 base-4.17.2.1
    base16-bytestring-1.0.2.0-LUU3ms9NsF4GQtyGeO8pva
    bifunctors-5.6.2-1Z7sUBZd1mCH05DXW3V4EJ binary-0.8.9.1
    binary-conduit-1.3.1-K46leAhY2G38MIvXKVxoIc bytestring-0.11.5.3
    bz2-1.0.1.1-1oTkjTdg1EjCNxosdlLLfq
    conduit-1.3.6.1-5zFQSWi5xEVBAmxL35th12
    conduit-extra-1.3.8-2EsBQsoEduiH5aGwZEbZVD containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.2-8dVLH0jap0Gp5bokZc6Zp
    errors-2.3.0-I7QCbpiUP3jGcT7tRKVUqU
    hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2
    incremental-parser-0.5.1-9Rs1fmVT6NU1tvHkE9EBGa
    ixset-typed-0.5.1.0-M2yTi8fv4LCqUPXj6OGUg
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-37qi4fIAhTC8owHWseusWs
    openpgp-asciiarmor-0.1.2-2Thl4Zg3NcdIvqHrwixx0O
    prettyprinter-1.7.1-5cxpZ3jZU7h3nFjq43pkKP
    resourcet-1.2.6-KmQzw70LfCm1KIvdRF4aq4
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    zlib-0.7.0.0-2F0fuaZf5oXJH9n2vtc6Ea

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

