#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-J5MbHHKCH9K69Jb2cDmpyC
key:                  hOpenPGP-2.10.1-J5MbHHKCH9K69Jb2cDmpyC
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  bde8209c2cc37cfe5a57dd50562805aa
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-J5MbHHKCH9K69Jb2cDmpyC
depends:
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig
    asn1-encoding-0.9.6-43l3cgH0zICDuaINH2UXie
    attoparsec-0.14.4-Kqu9azGoeFY4BlHGbH5HBg base-4.17.2.1
    base16-bytestring-1.0.2.0-2lCbsmyuV4cJM4iFUeYCbV
    bifunctors-5.6.2-1uCzk9Zj0rVFyj0BBmHMSQ binary-0.8.9.1
    binary-conduit-1.3.1-7z3Gfm5sdq69WGrgWt6UTd bytestring-0.11.5.3
    bz2-1.0.1.1-8v96F76ux3K1TUGY0A9NGu
    conduit-1.3.6.1-3M1B5TjJPZk646ipFSI00d
    conduit-extra-1.3.8-BV0bH3FRcPVLYpMYNDmntB containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-8eV5tKBVeMKJUHm3YWd3Uy
    errors-2.3.0-EmV6yZ3NmQpBuQ7JfNV2ye
    hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    incremental-parser-0.5.1-53ny2yd4sAU5Yaayx4t4xR
    ixset-typed-0.5.1.0-1OoonKsf5RI3wr0ei0E1X8
    lens-5.3.1-39Rj9LQQhPID4B1jmyDMFk
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-IX03DIUVxPAG8S8nkSZaDU
    openpgp-asciiarmor-0.1.2-6Gp5V40CS0YLUw4R36chqn
    prettyprinter-1.7.1-7LCr279S4u97FneESew6z
    resourcet-1.2.6-7iKUUdP710zAH2Mxgc0pA5
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    zlib-0.7.0.0-BbtlWgNylq2Ayu89f0aigE

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

