#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-e2ouwY4ZCJ4CePi7Ah5po
key:                  hOpenPGP-2.10.1-e2ouwY4ZCJ4CePi7Ah5po
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  16c28c225b29bb83b3ef8735873cbd5b
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-e2ouwY4ZCJ4CePi7Ah5po
depends:
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
    asn1-encoding-0.9.6-CkQwwdP6rQVIGy2OG6JPIw
    attoparsec-0.14.4-2LtDsLmLe3yKhxR8c5Iii0 base-4.17.2.1
    base16-bytestring-1.0.2.0-8PN9291fiWfGUTIhioOibg
    bifunctors-5.6.2-2wjKnuEOJQ2FcD6QGPTr8J binary-0.8.9.1
    binary-conduit-1.3.1-8EOm3vr4xT67zP5N25zEv2 bytestring-0.11.5.3
    bz2-1.0.1.1-7IPVQlarDOQBpTnf40Ccbo
    conduit-1.3.6.1-4Nkot2oDvonGGjTJfFocsW
    conduit-extra-1.3.8-8CivwHQF58ICNk5roA6vHC containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-1a41wQ1KUU04LsNwYijLXl
    errors-2.3.0-FTdvTQsi0yM3MPqp3fkKDk
    hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY
    incremental-parser-0.5.1-Ajv3XM2nb6mKJE17fGl95p
    ixset-typed-0.5.1.0-5YPxwCY0b5iAwkrx2RUQP9
    lens-5.3.1-1dHHf9jtSMJ2j1NVow6adv
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-2gUAl98MPyzDbzRsnMqG8p
    openpgp-asciiarmor-0.1.2-D2hD88Pb6wA3UeMScmGmXP
    prettyprinter-1.7.1-Da1BCiI1NV6LfdDEPEDf77
    resourcet-1.2.6-5radF0WuLJyBHOKTP8Jzte
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    zlib-0.7.0.0-HIFcmWkMcrQIACPrDtbc6U

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

