#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-3tV4aqYKdAUItzLcYbElJZ
key:                  hOpenPGP-2.10.1-3tV4aqYKdAUItzLcYbElJZ
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  e8f1779b99763f62e50f0f0ec7a51237
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-3tV4aqYKdAUItzLcYbElJZ
depends:
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
    asn1-encoding-0.9.6-A6IcF0Uym7ELxC29OBHboO
    attoparsec-0.14.4-CZt0qAnGZHQHCYZEsndAye base-4.17.2.1
    base16-bytestring-1.0.2.0-F3bh2T1ogzY4kBMIvDiuUI
    bifunctors-5.6.2-4DcN8T3FSjDKvhL4G6RNr0 binary-0.8.9.1
    binary-conduit-1.3.1-KU7IOsviOXwGpM4lPwoT7f bytestring-0.11.5.3
    bz2-1.0.1.1-4Yc61YIWbJ28ip2ODJ956p
    conduit-1.3.6.1-4gghCzlDHkwDP6CgdQyket
    conduit-extra-1.3.8-G9lFzvhsWCC98MvCUjkory containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-6f55tnn5Eqy3kGY0tzIamC
    errors-2.3.0-6764GECjLgs7DVa3tjyDnV
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7
    incremental-parser-0.5.1-E2x4kQYN0VsJ9P7gcD7wXo
    ixset-typed-0.5.1.0-L4yuPD5eS56HwZn9WCutRG
    lens-5.3.1-Jk0s21IZQ9F7Om7ixQU7VU
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-E36L5Munrgj3tkxSsgYpcw
    openpgp-asciiarmor-0.1.2-55xU7kbj7xnAPeZArDPNEk
    prettyprinter-1.7.1-Hi17Zu3O6FiIO5eybHbcRR
    resourcet-1.2.6-AVTqnIhFfb1JoG6KRaDalG
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    zlib-0.7.0.0-6noX1S9YwgbHMaaC248h30

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

