#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-60XdO4OGFAWArz0kpvNph3
key:                  hOpenPGP-2.10.1-60XdO4OGFAWArz0kpvNph3
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  b00da6f725745e715c0f62031a464113
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-60XdO4OGFAWArz0kpvNph3
depends:
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    asn1-encoding-0.9.6-ET1vn5gVP3QGemLlGFYiaH
    attoparsec-0.14.4-6kRuW0kw4gG3rg1QrsDffs base-4.17.2.1
    base16-bytestring-1.0.2.0-AZR9Ev6hMd0IJX97hPwFaq
    bifunctors-5.6.2-1eoC9JmP99h62plvJi35vB binary-0.8.9.1
    binary-conduit-1.3.1-ISWglwqI3qI7nS38FdwYte bytestring-0.11.5.3
    bz2-1.0.1.1-F65FbI8AgNrFY0OEwiy7L8
    conduit-1.3.6.1-P2VVzWMvOMICi7Nj7BTmx
    conduit-extra-1.3.8-4zxXchcBeveL56hfIzolRA containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-LKmr8qwXaarCiLjwP8DUaY
    errors-2.3.0-2W98ozJtBVWCPacaXfVxQ7
    hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ
    incremental-parser-0.5.1-VQK3hSLY9WGfHu1PRvvZo
    ixset-typed-0.5.1.0-DdVnFX6yNxR8M11z8jKIBh
    lens-5.3.1-2VSC1EMe0UsGg1l2wcItEv
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-FpQrzNLQnEFHV7gxKif8bC
    openpgp-asciiarmor-0.1.2-76HK8dTU3faBrYP10IQLXW
    prettyprinter-1.7.1-80F1dUtwFWzDp5CT3ZZVKz
    resourcet-1.2.6-9XnyFw86jRf1sw1PLhkl5l
    split-0.2.5-eIzaXXEViC764D7Uvb52H text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    zlib-0.7.0.0-GOInNFOI3XL1A6Gv5OWDAq

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

