#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-3Kaoi30M0To4ILw5jpNi0h
key:                  hOpenPGP-2.10.1-3Kaoi30M0To4ILw5jpNi0h
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  82051565e184780f99fb6b4166c3f75c
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-3Kaoi30M0To4ILw5jpNi0h
depends:
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4
    asn1-encoding-0.9.6-6yWOWuXnKgODn9ZNRHApWQ
    attoparsec-0.14.4-5QXKAIXHnspGYO0JElIsOr base-4.17.2.1
    base16-bytestring-1.0.2.0-ISe9mmeVuu6374zTlmWEXC
    bifunctors-5.6.2-8qEFHnQSYft7mo1QPa8LDR binary-0.8.9.1
    binary-conduit-1.3.1-1kmpUx6Q0rcAix0bYVCYYC bytestring-0.11.5.3
    bz2-1.0.1.1-DqtcSTl0vgV1tYSwfQRqOa
    conduit-1.3.6.1-LX1OqlTDVgXB5T9goEDWxI
    conduit-extra-1.3.8-DMXEhav2zajAIstf73Tomd containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-BOwwESl5wKY5wf5LQYyzlS
    errors-2.3.0-1em6dwOh6T2LUrx2QVnd3F
    hashable-1.4.5.0-46ofdJt9DgFJv5hpm4ccL9
    incremental-parser-0.5.1-7Oqn9GdsBsk2yNBOM61lgl
    ixset-typed-0.5.1.0-IsIh00vMu4IHzOQGz7JT5o
    lens-5.3.1-Ga5POsfLznm5CIw6bCU9JL
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-4IxerK0JG7wGRLJekUQEdr
    openpgp-asciiarmor-0.1.2-6rHabc24pk4Dkkgbpb9gDn
    prettyprinter-1.7.1-FOlixpN0mDDCGef0cfE7Yp
    resourcet-1.2.6-AJ1OoWHoMXT5AEQka8SZQl
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    zlib-0.7.0.0-5J8qtSnxQ9lBB7H0QqMVmL

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

