#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-LFOunZzdsp5KlR7BPZzSk
key:                  hOpenPGP-2.10.1-LFOunZzdsp5KlR7BPZzSk
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  9001b10e39bd5a7dca5ebea04aa4da68
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-LFOunZzdsp5KlR7BPZzSk
depends:
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7
    asn1-encoding-0.9.6-AnmO1s4tb3cAwxmZFlzCsW
    attoparsec-0.14.4-FxkaWaI1cCNBlT495krgLy base-4.17.2.1
    base16-bytestring-1.0.2.0-GJYqnQXROt0F72VvVyLJpe
    bifunctors-5.6.2-3SRqtSObL6qDHPufpMyPce binary-0.8.9.1
    binary-conduit-1.3.1-D5XYhcJ9JZ7FiIFsgTRdgY bytestring-0.11.5.3
    bz2-1.0.1.1-L9S8Bze9wTxAR1r5LmEkX8
    conduit-1.3.6.1-RIPQH88pa6HdGnxqZVAxX
    conduit-extra-1.3.8-Wf90Wdd777ELFlunPZvQx containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-580Na90wUfBI7I0w9U6WmP
    errors-2.3.0-IBGBqVrNsuSFgEY9qItzNB
    hashable-1.4.6.0-YmGjGgSp1PCYD264OAOUA
    incremental-parser-0.5.1-sE6vDhdjNNjyUjKSlm1b
    ixset-typed-0.5.1.0-KuPwani1JLlBHByYZzmrfb
    lens-5.3.2-3x6i1OAeQ2c8gg8RvgTRSW
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-EJq2qAYdDkaFqs6P7Upy96
    openpgp-asciiarmor-0.1.2-HXpv8ZA9ONpA6HC1xB92Y1
    prettyprinter-1.7.1-DU2dJrN5bRm6Aoduk8wHMr
    resourcet-1.2.6-85GJIioYIs529GIVOhD7J4
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    zlib-0.7.0.0-7Yfc1skJWQaC11O771G6OU

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

