#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-7w0mhAMfeEzIPGTO3uvfwL
key:                  hOpenPGP-2.10.1-7w0mhAMfeEzIPGTO3uvfwL
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  d017a4c17c5583bc3d74eec7e7514863
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-7w0mhAMfeEzIPGTO3uvfwL
depends:
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb
    asn1-encoding-0.9.6-55WpFv1w9MO4MQ0KDTmpda
    attoparsec-0.14.4-7a1Wj008Q4s1weDZNikOjh base-4.17.2.1
    base16-bytestring-1.0.2.0-20IAHeb4Utp2ZGQEDCbDdS
    bifunctors-5.6.2-GerV7vbeuVz93D14w0BMpJ binary-0.8.9.1
    binary-conduit-1.3.1-HQioA1dgkId5lg6TDTgoXd bytestring-0.11.5.3
    bz2-1.0.1.1-B3GZ5gSmAsEBEK6jVQeer6
    conduit-1.3.6.1-CtNjiY6d9ioJN2CqltSeEi
    conduit-extra-1.3.8-E6affjwsmt94hD5QSBQcbY containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.4-6r7difyxiE08uhXDhecjzk
    errors-2.3.0-JMmq8sVkkG6NcWnJztQLH
    hashable-1.4.6.0-HNsjIjcKtfz4EPsBV3Crzv
    incremental-parser-0.5.1-L5hHz9OGeCa6iKUK1wIH0V
    ixset-typed-0.5.1.0-59YouLCLfiv4faQUPMgYzq
    lens-5.3.2-DlnMzXp6T2vRa3tLj6rdI
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-Db65q7JXyy8EWWIZuTCsbL
    openpgp-asciiarmor-0.1.2-9KkHThuCnp28pSMZdDqyPm
    prettyprinter-1.7.1-KHTd6ELn8JD9j39b7JIrXU
    resourcet-1.2.6-Hn3iki8FnUnhtk8gvTYAI
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    zlib-0.7.0.0-9RCw7pyUn6iFIiRGsiNi6

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

