#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hslogger
version:              1.3.1.2
visibility:           public
id:                   hslogger-1.3.1.2-7cQcJPLUXZcJJrv1fX8vXI
key:                  hslogger-1.3.1.2-7cQcJPLUXZcJJrv1fX8vXI
license:              BSD-3-Clause
copyright:
    Copyright (c) 2004-2018 John Goerzen
    , (c) 2019      Herbert Valerio Riedel

maintainer:           https://github.com/haskell-hvr/hslogger
author:               John Goerzen
homepage:             https://github.com/haskell-hvr/hslogger/wiki
synopsis:             Versatile logging framework
description:
    @hslogger@ is a logging framework for Haskell, roughly similar
    to [Python'\''s logging module](https://docs.python.org/2/library/logging.html).

    @hslogger@ lets each log message have a priority and source be associated
    with it.  The programmer can then define global handlers that route
    or filter messages based on the priority and source.  @hslogger@ also
    has a [Syslog](https://tools.ietf.org/html/rfc5424) handler built in.

category:             Interfaces
abi:                  219bbb6829be70caceef2f27d5ee02ff
exposed:              True
exposed-modules:
    System.Log System.Log.Formatter System.Log.Handler
    System.Log.Handler.Growl System.Log.Handler.Log4jXML
    System.Log.Handler.Simple System.Log.Handler.Syslog
    System.Log.Logger

hidden-modules:       UTF8
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hslogger-1.3.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hslogger-1.3.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hslogger-1.3.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslogger
hs-libraries:         HShslogger-1.3.1.2-7cQcJPLUXZcJJrv1fX8vXI
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    network-3.1.4.0-ItBhIFDvz12FCCKfYobIMX
    network-bsd-2.8.1.0-AFh2WFCoL5pHjaTZ9bNOdj
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh time-1.12.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-hslogger/html/hslogger.haddock
haddock-html:         /usr/share/doc/haskell-hslogger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

