#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   HsOpenSSL
version:                0.11.7.9
visibility:             public
id:                     HsOpenSSL-0.11.7.9-3NJ65ZSUqao9C85OYSQe7e
key:                    HsOpenSSL-0.11.7.9-3NJ65ZSUqao9C85OYSQe7e
license:                LicenseRef-PublicDomain
maintainer:             Vladimir Shabanov <dev@vshabanov.com>
author:                 Adam Langley, Mikhail Vorozhtsov, PHO, Taru Karttunen
stability:              stable
homepage:               https://github.com/haskell-cryptography/HsOpenSSL
synopsis:               Partial OpenSSL binding for Haskell
description:
    HsOpenSSL is an OpenSSL binding for Haskell. It can generate RSA
    and DSA keys, read and write PEM files, generate message digests,
    sign and verify messages, encrypt and decrypt messages. It has
    also some capabilities of creating SSL clients and servers.

    This package is in production use by a number of Haskell based
    systems and stable. You may also be interested in the @tls@ package,
    <http://hackage.haskell.org/package/tls>, which is a pure Haskell
    implementation of SSL.

category:               Cryptography
abi:                    24c27199d24e06cece1972cc3045385c
exposed:                True
exposed-modules:
    OpenSSL OpenSSL.BN OpenSSL.Cipher OpenSSL.DER OpenSSL.DH
    OpenSSL.DSA OpenSSL.EVP.Base64 OpenSSL.EVP.Cipher
    OpenSSL.EVP.Digest OpenSSL.EVP.Internal OpenSSL.EVP.Open
    OpenSSL.EVP.PKey OpenSSL.EVP.Seal OpenSSL.EVP.Sign
    OpenSSL.EVP.Verify OpenSSL.PEM OpenSSL.PKCS7 OpenSSL.RSA
    OpenSSL.Random OpenSSL.Session OpenSSL.X509 OpenSSL.X509.Request
    OpenSSL.X509.Revocation OpenSSL.X509.Store

hidden-modules:
    OpenSSL.ASN1 OpenSSL.BIO OpenSSL.ERR OpenSSL.Objects
    OpenSSL.SSL.Option OpenSSL.Stack OpenSSL.Utils OpenSSL.X509.Name
    OpenSSL.DH.Internal

import-dirs:            /usr/lib/ghc-9.4.8/site-local/HsOpenSSL-0.11.7.9
library-dirs:           /usr/lib/ghc-9.4.8/site-local/HsOpenSSL-0.11.7.9
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/HsOpenSSL-0.11.7.9
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-hsopenssl
hs-libraries:           HSHsOpenSSL-0.11.7.9-3NJ65ZSUqao9C85OYSQe7e
extra-libraries:        ssl crypto
extra-libraries-static: ssl crypto dl
includes:               openssl/asn1.h
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    network-3.1.4.0-JHT56NFIotXJvLJoz7gUbr time-1.12.2

haddock-interfaces:     /usr/share/doc/haskell-hsopenssl/html/HsOpenSSL.haddock
haddock-html:           /usr/share/doc/haskell-hsopenssl/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

