#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTF
version:              0.15.0.2
visibility:           public
id:                   HTF-0.15.0.2-DSwxWvThhI6LRMyAVpH0k
key:                  HTF-0.15.0.2-DSwxWvThhI6LRMyAVpH0k
license:              LGPL-2.1-only
copyright:            (c) 2005-2024 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  75ac450701e53e2e4986a0f037541a77
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.2-DSwxWvThhI6LRMyAVpH0k
depends:
    Diff-0.5-CuN0gcwErnxTovm8uRK5M HUnit-1.6.2.0-JJtnl2yaWp5IW6ez6BsjYT
    QuickCheck-2.15.0.1-4O3a6KCv0r3IEepy258gow
    aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto array-0.5.4.0 base-4.17.2.1
    base64-bytestring-1.2.1.0-KTcFt1JBtqE6XrF8UIUkhn
    bytestring-0.11.5.3 containers-0.6.7
    cpphs-1.20.9.1-KMTErBmnvc26XA8bncSIwV directory-1.3.7.1
    haskell-src-1.0.4.1-Hixlkf9qLz3LueBNFxe25l
    lifted-base-0.2.3.12-Dr8t8nefaNA9F2PFiN5bjV
    monad-control-1.0.3.1-Gznm0l8Lbkh1N6Qfynm2B4 mtl-2.2.2
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.3-BS01zQf871D7daMTFQ0UbO
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 text-2.0.2 time-1.12.2
    unix-2.7.3 vector-0.13.2.0-BnQJYTBpbJKJ2sldbPuyJj
    xmlgen-0.6.2.2-6dvZNdXuguE9xRkMSieHaq

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

