#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http-media
version:              0.8.1.1
visibility:           public
id:                   http-media-0.8.1.1-KrKMKuOu1FE14cpUKNtMX9
key:                  http-media-0.8.1.1-KrKMKuOu1FE14cpUKNtMX9
license:              MIT
copyright:            (c) 2012-2023 Timothy Jones
maintainer:           Timothy Jones <tim@zmthy.net>
author:               Timothy Jones
homepage:             https://github.com/zmthy/http-media
synopsis:             Processing HTTP Content-Type and Accept headers
description:
    This library is intended to be a comprehensive solution to parsing and
    selecting quality-indexed values in HTTP headers.  It is capable of
    parsing both media types and language parameters from the Accept and
    Content header families, and can be extended to match against other
    accept headers as well.  Selecting the appropriate header value is
    achieved by comparing a list of server options against the
    quality-indexed values supplied by the client.

    In the following example, the Accept header is parsed and then matched
    against a list of server options to serve the appropriate media using
    '\''mapAcceptMedia'\'':

    > getHeader >>= maybe send406Error sendResourceWith . mapAcceptMedia
    >     [ ("text/html",        asHtml)
    >     , ("application/json", asJson)
    >     ]

    Similarly, the Content-Type header can be used to produce a parser for
    request bodies based on the given content type with '\''mapContentMedia'\'':

    > getContentType >>= maybe send415Error readRequestBodyWith . mapContentMedia
    >     [ ("application/json", parseJson)
    >     , ("text/plain",       parseText)
    >     ]

    The API is agnostic to your choice of server.

category:             Web
abi:                  c0b4e26d5daf2d0ff585335ec8a06c17
exposed:              True
exposed-modules:
    Network.HTTP.Media Network.HTTP.Media.Accept
    Network.HTTP.Media.Charset Network.HTTP.Media.Encoding
    Network.HTTP.Media.Language Network.HTTP.Media.MediaType
    Network.HTTP.Media.RenderHeader

hidden-modules:
    Network.HTTP.Media.Charset.Internal
    Network.HTTP.Media.Encoding.Internal
    Network.HTTP.Media.Language.Internal
    Network.HTTP.Media.MediaType.Internal Network.HTTP.Media.Quality
    Network.HTTP.Media.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/http-media-0.8.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http-media-0.8.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http-media-0.8.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-media
hs-libraries:         HShttp-media-0.8.1.1-KrKMKuOu1FE14cpUKNtMX9
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Dv0qc5eM6SdL4nJsx4bnK containers-0.6.7
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB

haddock-interfaces:   /usr/share/doc/haskell-http-media/html/http-media.haddock
haddock-html:         /usr/share/doc/haskell-http-media/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

