#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hw-fingertree
version:              0.1.2.1
visibility:           public
id:                   hw-fingertree-0.1.2.1-4LzES6qPmD11YeeKjUKDxf
key:                  hw-fingertree-0.1.2.1-4LzES6qPmD11YeeKjUKDxf
license:              BSD-3-Clause
copyright:
    (c) 2017-2022 John Ky
    (c) 2006 Ross Paterson, Ralf Hinze,

maintainer:           John Ky <newhoggy@gmail.com>
homepage:             https://github.com/haskell-works/hw-fingertree#readme
synopsis:             Generic finger-tree structure, with example instances
description:
    A general sequence representation with arbitrary
    annotations, for use as a base for implementations of
    various collection types, with examples, as described
    in section 4 of

    * Ralf Hinze and Ross Paterson,
    \"Finger trees: a simple general-purpose data structure\",
    /Journal of Functional Programming/ 16:2 (2006) pp 197-217.
    <http://staff.city.ac.uk/~ross/papers/FingerTree.html>

    For a tuned sequence type, see @Data.Sequence@ in the
    @containers@ package, which is a specialization of
    this structure.

category:             Data Structures
abi:                  cbc1ad9dd3ecc6b61e9d49dfe34ff555
exposed:              True
exposed-modules:
    HaskellWorks.Data.FingerTree
    HaskellWorks.Data.IntervalMap.FingerTree
    HaskellWorks.Data.PriorityQueue.FingerTree

hidden-modules:       Paths_hw_fingertree
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hw-fingertree-0.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hw-fingertree-0.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hw-fingertree-0.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hw-fingertree
hs-libraries:         HShw-fingertree-0.1.2.1-4LzES6qPmD11YeeKjUKDxf
depends:
    base-4.17.2.1 deepseq-1.4.8.0
    hw-prim-0.6.3.2-BrbBPNbuoo5ADVqkeOxNvy

haddock-interfaces:
    /usr/share/doc/haskell-hw-fingertree/html/hw-fingertree.haddock

haddock-html:         /usr/share/doc/haskell-hw-fingertree/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

