#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 infinite-list
version:              0.1.2
visibility:           public
id:                   infinite-list-0.1.2-81JesnX4jjUGsSuueZvzyQ
key:                  infinite-list-0.1.2-81JesnX4jjUGsSuueZvzyQ
license:              BSD-3-Clause
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/infinite-list
synopsis:             Infinite lists
description:
    Modern lightweight library for infinite lists with fusion:

    * API similar to "Data.List".
    * No dependencies other than `base`.
    * Top performance, driven by fusion.
    * Avoid dangerous instances like `Foldable`.
    * Use `NonEmpty` where applicable.
    * Use `Word` for indices.
    * Be lazy, but not too lazy.

    @
    {\-# LANGUAGE PostfixOperators #-\}
    import Data.List.Infinite (Infinite(..), (...), (....))
    import qualified Data.List.Infinite as Inf
    @

category:             Data
abi:                  2c9e5f2b0943c3c70e144077fe5fe9f9
exposed:              True
exposed-modules:      Data.List.Infinite
hidden-modules:
    Data.List.Infinite.Internal Data.List.Infinite.Set
    Data.List.Infinite.Zip

import-dirs:          /usr/lib/ghc-9.4.8/site-local/infinite-list-0.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/infinite-list-0.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/infinite-list-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-infinite-list
hs-libraries:         HSinfinite-list-0.1.2-81JesnX4jjUGsSuueZvzyQ
depends:              base-4.17.2.1
haddock-interfaces:
    /usr/share/doc/haskell-infinite-list/html/infinite-list.haddock

haddock-html:         /usr/share/doc/haskell-infinite-list/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

