#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 IOSpec
version:              0.3.1.2
visibility:           public
id:                   IOSpec-0.3.1.2-26YIS0I5k31KOFfmolocca
key:                  IOSpec-0.3.1.2-26YIS0I5k31KOFfmolocca
license:              BSD-3-Clause
maintainer:           Bertram Felgenhauer <int-e@gmx.de>
author:
    Wouter Swierstra,
    Yusaku Hashimoto,
    Nikolay Amiantov,
    Bertram Felgenhauer

homepage:             https://github.com/lambdabot/IOSpec
synopsis:             A pure specification of the IO monad.
description:
    This package consists of several modules, that give a
    pure specification of functions in the IO monad:

    * "Test.IOSpec.Fork": a pure specification of
    '\''forkIO'\''.
    * "Test.IOSpec.IORef": a pure specification of most
    functions that create and manipulate on '\''IORefs'\''.
    * "Test.IOSpec.MVar": a pure specification of most
    functions that create and manipulate and '\''MVars'\''.
    * "Test.IOSpec.STM": a pure specification of
    '\''atomically'\'' and the '\''STM'\'' monad.
    * "Test.IOSpec.Teletype": a pure specification of
    '\''getChar'\'', '\''putChar'\'', and several related
    Prelude functions.

    Besides these modules containing the specifications,
    there are a few other important modules:

    * "Test.IOSpec.Types": defines the '\''IOSpec'\'' type and
    several amenities.
    * "Test.IOSpec.VirtualMachine": defines a virtual
    machine on which to execute pure specifications.
    * "Test.IOSpec.Surrogate": a drop-in replacement for
    the other modules. Import this and recompile your
    code once you'\''ve finished testing and debugging.

    There are several well-documented examples included
    with the source distribution.

category:             Testing
abi:                  e542c0d806fce1800774b44356f0828f
exposed:              True
exposed-modules:
    Test.IOSpec Test.IOSpec.Fork Test.IOSpec.IORef Test.IOSpec.MVar
    Test.IOSpec.STM Test.IOSpec.Surrogate Test.IOSpec.Teletype
    Test.IOSpec.Types Test.IOSpec.VirtualMachine

import-dirs:          /usr/lib/ghc-9.4.8/site-local/IOSpec-0.3.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/IOSpec-0.3.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/IOSpec-0.3.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-iospec
hs-libraries:         HSIOSpec-0.3.1.2-26YIS0I5k31KOFfmolocca
depends:
    QuickCheck-2.14.3-5RH984QQwd07L7POXdEIyh
    Stream-0.4.7.2-3CIysL4OtRRLSnHhTDvFOr base-4.17.2.1 mtl-2.2.2

haddock-interfaces:   /usr/share/doc/haskell-iospec/html/IOSpec.haddock
haddock-html:         /usr/share/doc/haskell-iospec/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

