#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-5puVtcGnxr12lx90T32DyL
key:                  jose-0.10-5puVtcGnxr12lx90T32DyL
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  74385e1c347fdaf7a0ca58c3086fd388
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.4.8/site-local/jose-0.10
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-5puVtcGnxr12lx90T32DyL
depends:
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 concise-0.1.0.1-L1EjrmX5h1fACKVW8QUWgs
    containers-0.6.7 cryptonite-0.30-G6fxRav5DcXE7HrFU9fmXJ
    lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-time-0.4.0.0-LPoHPY62S3DIdducY8Hb6X mtl-2.2.2
    network-uri-2.6.4.2-KmmPt5MfJi07BPtstNPoD0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    x509-1.7.7-GR2mzwJc2cP1SAbDoZ0enV

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

