#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-7xFRPbjxdPZ8y4wRPhO8AZ
key:                  lsp-2.1.0.0-7xFRPbjxdPZ8y4wRPhO8AZ
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  478726e9c415b21f0aa2abcfacbf5409
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-ERiHsbrIFJX8GWb1FzfnMP:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-ERiHsbrIFJX8GWb1FzfnMP:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-ERiHsbrIFJX8GWb1FzfnMP:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-ERiHsbrIFJX8GWb1FzfnMP:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-7xFRPbjxdPZ8y4wRPhO8AZ
depends:
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC
    async-2.2.5-Fwc3ABGHG7o8WWC3l3QDRi
    attoparsec-0.14.4-AfQEBsI4KfUBbsB9NxUVAd base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-7m6HuklLii64LMQ1MpN6iG
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb
    lens-5.3.1-LF4jCoE0w776e2gq32lhyl
    lsp-types-2.0.1.0-ERiHsbrIFJX8GWb1FzfnMP mtl-2.2.2
    prettyprinter-1.7.1-5xgqmGXqgSr2RPa1NTsZyQ
    random-1.2.1.3-2cudg871s2f2tL4YjAU8WJ
    row-types-1.0.1.2-JUPGubFZ6cE3E4LlCuUdLY
    sorted-list-0.2.3.1-GLhvvqV7QQD5fX9Krb1rr5 stm-2.5.1.0
    temporary-1.3-836zY2cPz8HAaBXH2WMEd1 text-2.0.2
    text-rope-0.3-GDm3yeD8AoS1PxPruyvWGM transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    uuid-1.3.16-Lkoa9WUokygHxRiL5Bnkfi

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

