#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-FIUxRBZPO0c6Yu7Vd1pRxF
key:                  lsp-2.1.0.0-FIUxRBZPO0c6Yu7Vd1pRxF
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  a525f771cedda8b57cff16aeaddaa382
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-Js53NLAuQ1WDo1VfZm5Gp5:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-Js53NLAuQ1WDo1VfZm5Gp5:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-Js53NLAuQ1WDo1VfZm5Gp5:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-Js53NLAuQ1WDo1VfZm5Gp5:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-FIUxRBZPO0c6Yu7Vd1pRxF
depends:
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
    async-2.2.5-HMp4lCE5MFwDsdQT9P7pHP
    attoparsec-0.14.4-GuMPfMcqjBDDq1IerlxPtw base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-Hhp4yJJfgcIMVKIO8OhoL
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-BEEuzU8Xb1pET12cUzIyiR
    lens-5.3.1-EQU0Jo6uxppBYuhl3GuXTA
    lsp-types-2.0.1.0-Js53NLAuQ1WDo1VfZm5Gp5 mtl-2.2.2
    prettyprinter-1.7.1-JBUxpob9pPVLD8OaO2d4B1
    random-1.2.1.3-1ICINoe1N4e7cLBAPqefIx
    row-types-1.0.1.2-H4qPWOYgfcQ6OWip2uzDNF
    sorted-list-0.2.3.1-3maf2qUyB3jLA07pEohVtk stm-2.5.1.0
    temporary-1.3-3mtZbkJPoBb5nlmfkfYt6T text-2.0.2
    text-rope-0.3-LV2zkuoq1IwL5G8zG6wopc transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-IhcdMC6aki1KSQ4zttUKBR
    uuid-1.3.16-E94tJlD3hEQJwX865gS6xP

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

