#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-JU5i2Vc8ZS82SaQjYglsrU
key:                  lsp-2.1.0.0-JU5i2Vc8ZS82SaQjYglsrU
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  143b86ba81b19499e0bd40890d01bbe8
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-2gRW45LsX92DAXc8BUpFa:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-2gRW45LsX92DAXc8BUpFa:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-2gRW45LsX92DAXc8BUpFa:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-2gRW45LsX92DAXc8BUpFa:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-JU5i2Vc8ZS82SaQjYglsrU
depends:
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq
    async-2.2.5-1z0oB69LG2FBRno1il1zoZ
    attoparsec-0.14.4-KCzcP2UZhdCHukFfOxO6Y base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-FOGUXhz3ujl8MDW7xoi5oG
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg
    lens-5.3.1-D1RUGLJD0B7IsqWvzdm040
    lsp-types-2.0.1.0-2gRW45LsX92DAXc8BUpFa mtl-2.2.2
    prettyprinter-1.7.1-Fh4Rajbxlmi9sLGTMcb6xB
    random-1.2.1.3-1epqCSzcS4p5bPWcI4Ab0S
    row-types-1.0.1.2-HG8gnzF0YFVDRAZjCHLpIY
    sorted-list-0.2.3.1-ANkruaYZsOe4QhdDQ0KTiV stm-2.5.1.0
    temporary-1.3-G3JGTlFyfueEWhF9il8L2k text-2.0.2
    text-rope-0.3-I39s4NB8GX5GSubck3y6A transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    uuid-1.3.16-41UNy0cv50pDk0xRPtEdvG

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

