#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-Kiwz8EEQvc48qLiZOstxby
key:                  lsp-2.1.0.0-Kiwz8EEQvc48qLiZOstxby
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  045be69e5944ca6f1d0d7547da5b9145
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-JG7SnVpOhAcBiQYIFpAyY3:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-JG7SnVpOhAcBiQYIFpAyY3:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-JG7SnVpOhAcBiQYIFpAyY3:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-JG7SnVpOhAcBiQYIFpAyY3:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-Kiwz8EEQvc48qLiZOstxby
depends:
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
    async-2.2.5-Cu6iyHAzE8GPfJTsQBFL9
    attoparsec-0.14.4-EuJHdCyQx9qFeM6j3QZsTf base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-3HJgHd5Ail8L8m6aGfYDpY
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-92QHxum7zjW25fH5Mdbvto
    lens-5.3.1-LjfZJ7QVgZYGOTr5fwppHy
    lsp-types-2.0.1.0-JG7SnVpOhAcBiQYIFpAyY3 mtl-2.2.2
    prettyprinter-1.7.1-27Ta3g9m3VQHgx6FjDiyXu
    random-1.2.1.3-6y99CLYUqOs4N5Dmmd11Ha
    row-types-1.0.1.2-6jBrFUoFWi5LDhESPvJxfV
    sorted-list-0.2.3.1-HaTURUEDJS9Xghvwza7kL stm-2.5.1.0
    temporary-1.3-AgnyQJqoH2tBVE9T1YksW9 text-2.0.2
    text-rope-0.3-1O1vH6KDOZ1Jsig029VapO transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    uuid-1.3.16-DanzINKvYx15Ks0b7zIKaS

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

