#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-LXmhQ6CLYNl2E3mVoUaxLM
key:                  lsp-2.1.0.0-LXmhQ6CLYNl2E3mVoUaxLM
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  ffdd4bd00f187400e9768419566f541d
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-Kej5qdSEEzgAzabbYgdn2j:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-Kej5qdSEEzgAzabbYgdn2j:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-Kej5qdSEEzgAzabbYgdn2j:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-Kej5qdSEEzgAzabbYgdn2j:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-LXmhQ6CLYNl2E3mVoUaxLM
depends:
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
    async-2.2.5-CA4aEq3ECoz7BppWAZygZ1
    attoparsec-0.14.4-AaLxHw66o7ZDAbKIqXiED8 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-5zuRN6Yf5ctE5QgiXRJ1Wd
    containers-0.6.7 data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-HmFtE5Wyl97MxSGTvKCoh
    lens-5.3.1-58EqPfReeF86v3dzDdfR9b
    lsp-types-2.0.1.0-Kej5qdSEEzgAzabbYgdn2j mtl-2.2.2
    prettyprinter-1.7.1-CsTpPkPqzgLjuO06MZsX5
    random-1.2.1.3-BJci0ZIHWY7JJvOpU5NHzK
    row-types-1.0.1.2-11VJuJH0CxoFFLSW9uDYrj
    sorted-list-0.2.3.1-LR5HI8Ugpv8BArFyu8j757 stm-2.5.1.0
    temporary-1.3-BUD9rQS749x5bLVTfwQ4gp text-2.0.2
    text-rope-0.3-IsMOQhOfMBWA7YtTK99AlK transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    uuid-1.3.16-Jc2WSMIN71EG9lK7bB1JO4

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

