#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-29RikuAbvDiEhXUbeBa8OX
key:                  lsp-2.1.0.0-29RikuAbvDiEhXUbeBa8OX
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  25df3a139fee2a25d2b996a7e4cb9c8c
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-AvYxyzFnv749XghvZ5DYoi:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-AvYxyzFnv749XghvZ5DYoi:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-AvYxyzFnv749XghvZ5DYoi:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-AvYxyzFnv749XghvZ5DYoi:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-29RikuAbvDiEhXUbeBa8OX
depends:
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig
    async-2.2.5-6I3Om2iOc9KLV2rb6dASmz
    attoparsec-0.14.4-Kqu9azGoeFY4BlHGbH5HBg base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-6DH6hXYdZ2l5qz5nztRopB
    containers-0.6.7 data-default-0.7.1.2-1WYBg9tpZep2i2jrc12PQs
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    lens-5.3.1-39Rj9LQQhPID4B1jmyDMFk
    lsp-types-2.0.1.0-AvYxyzFnv749XghvZ5DYoi mtl-2.2.2
    prettyprinter-1.7.1-7LCr279S4u97FneESew6z
    random-1.2.1.3-Dut5c8vSKZWHge6fwh5bUA
    row-types-1.0.1.2-2xtYGr5rLV22eJcswKdUW5
    sorted-list-0.2.3.1-KACJSneUcTXLqVGo3una73 stm-2.5.1.0
    temporary-1.3-Hhl2LRPiMvQ4xmTU7fPXaD text-2.0.2
    text-rope-0.3-4Qyfm5oooJ87dcLSXg5ijp transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    uuid-1.3.16-GJSG7HiE4PXIztKocWTNuc

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

