#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-b02KkAmTxV7yZ6tPxe7VB
key:                  lsp-2.1.0.0-b02KkAmTxV7yZ6tPxe7VB
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  353ec838b6a264f6a63779abfaca5822
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-FsFiNjU51v1BpYzCrGT5js:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-FsFiNjU51v1BpYzCrGT5js:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-FsFiNjU51v1BpYzCrGT5js:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-FsFiNjU51v1BpYzCrGT5js:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-b02KkAmTxV7yZ6tPxe7VB
depends:
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP
    async-2.2.5-BbhpjNcetBn7sq4yuFYnd1
    attoparsec-0.14.4-G1kY79wp4BCwb0EQHIFQA base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-8yYdsHyduyXAZyVsSucUvo
    containers-0.6.7 data-default-0.7.1.2-GUUW0V5lisrJnDmYs4YZIH
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-L4Cy5OzOiFo7EDda82f1f2
    lens-5.3.1-7KUGOKnL0sFAtVCcawlRvA
    lsp-types-2.0.1.0-FsFiNjU51v1BpYzCrGT5js mtl-2.2.2
    prettyprinter-1.7.1-H1CnA9YdkYYkwP4aBwQ7e
    random-1.2.1.3-2jtdg0FBSKzAasSf5KWDPe
    row-types-1.0.1.2-KTilnchipXT3DxixXa2arS
    sorted-list-0.2.3.1-GacfgcHQkFlCRDzot3G4CX stm-2.5.1.0
    temporary-1.3-Bz9UHoeAgBV21I7419KVlH text-2.0.2
    text-rope-0.3-2qQx024gOA4JCBubpvEpn6 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    uuid-1.3.16-H6wTQZCEbfUDs3BNV1jl4c

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

