#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-GqUkT7LWD5z2j8vkLZwoGo
key:                  lsp-2.1.0.0-GqUkT7LWD5z2j8vkLZwoGo
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  5bd4687daf1f3bd09a4ad0db33caa8f8
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-FG5BWlrUV2lI4l6HCIYHLz:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-FG5BWlrUV2lI4l6HCIYHLz:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-FG5BWlrUV2lI4l6HCIYHLz:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-FG5BWlrUV2lI4l6HCIYHLz:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-GqUkT7LWD5z2j8vkLZwoGo
depends:
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
    async-2.2.5-JGCoQdxZuXN6RYZ81Kl1U4
    attoparsec-0.14.4-IXbcbJGX0cBC8WVvSy4ntj base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-LAU5XbaabRA4nm6HZzBOOD
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.5.0-FhpNKvHQsJeLXuGJFx8piW
    lens-5.3.1-K6M28KdwyDFInfMmFpBOSR
    lsp-types-2.0.1.0-FG5BWlrUV2lI4l6HCIYHLz mtl-2.2.2
    prettyprinter-1.7.1-1kfTx5RMvNJHRpCjVrY3F5
    random-1.2.1.3-LY8g0he9kPzH0WCF9vQLty
    row-types-1.0.1.2-6bQ4XmZzRIc5bTtZdaKk6z
    sorted-list-0.2.3.1-DryZdCrKa19KSfcnWICuFx stm-2.5.1.0
    temporary-1.3-Hp6jkQ9rtgX3Zx1BXXhTu3 text-2.0.2
    text-rope-0.3-8choKXe2z42JJr6vo4xnZK transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    uuid-1.3.16-8DXJEeeES9kGcCaO3OL4N3

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

