#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-LxSKkJdBj4g1eg9hTKXJFR
key:                  lsp-2.1.0.0-LxSKkJdBj4g1eg9hTKXJFR
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  bbc53d357abcb801b4324198bb0346b5
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-L0CJbqCy75K7XVQObbAJuS:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-L0CJbqCy75K7XVQObbAJuS:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-L0CJbqCy75K7XVQObbAJuS:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-L0CJbqCy75K7XVQObbAJuS:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-LxSKkJdBj4g1eg9hTKXJFR
depends:
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
    async-2.2.5-FyJFxj28VNy7uaj8UqY8bG
    attoparsec-0.14.4-H7aeDSX4mnyDRaYndD48j5 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-58hiaW4ZEM9H4BgMjjCg2M
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f
    lens-5.3.1-JQiC8s3SxPvAYItR1bILVE
    lsp-types-2.0.1.0-L0CJbqCy75K7XVQObbAJuS mtl-2.2.2
    prettyprinter-1.7.1-GISel4GwMefHj3FidpnW09
    random-1.2.1.3-5Vfv7B7ZdGT6rasffmKWRk
    row-types-1.0.1.2-K5DRzsryRVALQnVzPH62US
    sorted-list-0.2.3.1-36GmI14pfs2GFJ4i9Umud4 stm-2.5.1.0
    temporary-1.3-1x1h49uB6HQBNYAxVFima5 text-2.0.2
    text-rope-0.3-3UP3R4r8Q8EDt6rcOuuDik transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    uuid-1.3.16-Bl9xkMof8FZC1vqH9i1Mdj

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

