#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-JxmIZMl2v9k6LfbUc7lPpP
key:                  lsp-2.1.0.0-JxmIZMl2v9k6LfbUc7lPpP
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  efc3d073dd2d5c0e92b42927edacc309
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-G8vNo2JYc1MK75jcd0jM9C:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-G8vNo2JYc1MK75jcd0jM9C:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-G8vNo2JYc1MK75jcd0jM9C:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-G8vNo2JYc1MK75jcd0jM9C:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-JxmIZMl2v9k6LfbUc7lPpP
depends:
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31
    async-2.2.5-1XszS28nMj91eBjCxIzBEt
    attoparsec-0.14.4-IvgQrznNozFJRhxLBW8JF base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-2vVgnj0Qh7rHUzhTJH0ciX
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0
    lens-5.3.1-ph5gK6GMHDK3KRhjZ6UP9
    lsp-types-2.0.1.0-G8vNo2JYc1MK75jcd0jM9C mtl-2.2.2
    prettyprinter-1.7.1-Akkp0WpHSIjZLnKQ6G5af
    random-1.2.1.3-H7b6I1swtfqDNx62GlcOH8
    row-types-1.0.1.2-IkoWr6txzWrEA3XewR2JtI
    sorted-list-0.2.3.1-2fuSBINCHDQtGDKy6WIeS stm-2.5.1.0
    temporary-1.3-DvBGl4XgxXUEV6N6poxsKk text-2.0.2
    text-rope-0.3-AKRfHbWxPrQ3IAMo7Sqn5b transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    uuid-1.3.16-EhXidLed9gM6Z7XoSBy8d6

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

