#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-H4YQXeowIYYF1u0BIVs9vq
key:                  lsp-2.1.0.0-H4YQXeowIYYF1u0BIVs9vq
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  991476e3bad23dbf3530061e573fed3e
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-IMQxeBEGCdRGmzeiiwonCf:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-IMQxeBEGCdRGmzeiiwonCf:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-IMQxeBEGCdRGmzeiiwonCf:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-IMQxeBEGCdRGmzeiiwonCf:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-H4YQXeowIYYF1u0BIVs9vq
depends:
    aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY
    async-2.2.5-GQPCMKT2tm99KQt4aOAXPc
    attoparsec-0.14.4-Fn7js8xKpz57gY212YnEkw base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-GhJO8BTQBcX39sPJgGPAVc
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.6.0-AVmZwVVVmv9PclG6VBq0Z
    lens-5.3.2-Exg2qZYOG9zJ2AlH8CiZ0W
    lsp-types-2.0.1.0-IMQxeBEGCdRGmzeiiwonCf mtl-2.2.2
    prettyprinter-1.7.1-6LAznmhuiuZGYtT9LOkZPA
    random-1.2.1.3-53eBMyqCn4j5j5sTN6ACJa
    row-types-1.0.1.2-47ZdBxMYPEd9TzqcRPYv2l
    sorted-list-0.2.3.1-7Qrnpi1dftpJWyFP4QpPmv stm-2.5.1.0
    temporary-1.3-J42K7A8FBeY81ggJOcRHJy text-2.0.2
    text-rope-0.3-Lk7HujwzMaP4umlTL14tSn transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-9npXt9Xm1lq5WoODUfmSXc
    uuid-1.3.16-JZldhWwp7KFJM7wY1nGxWy

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

