#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-736YImsOgnd1fKorlgmicl
key:                  lsp-2.1.0.0-736YImsOgnd1fKorlgmicl
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  e16ff77a9dcb9f1a7b3508abaaae7e53
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-rbTn4aGunV9tjBHdYuF11:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-rbTn4aGunV9tjBHdYuF11:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-rbTn4aGunV9tjBHdYuF11:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-rbTn4aGunV9tjBHdYuF11:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-736YImsOgnd1fKorlgmicl
depends:
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    async-2.2.5-EP91qAI3cOI8P3d6QWskI6
    attoparsec-0.14.4-4euoXrooDbuLZe6Xn3rp2d base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-CiFyX5luoGE3ZQ6hLne706
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo
    lens-5.3.3-6oW8YfnpumtF66FcI0BTsr
    lsp-types-2.0.1.0-rbTn4aGunV9tjBHdYuF11 mtl-2.2.2
    prettyprinter-1.7.1-2fDIWQCpfcFF0VMlKg6ON0
    random-1.2.1.3-8ADb21VvJl3AtsgmJLZ0Jg
    row-types-1.0.1.2-7cQtIZqpIUJL7SOEb6Hq6Y
    sorted-list-0.2.3.1-KiT5KkWVSzr8zB2oFJoGg1 stm-2.5.1.0
    temporary-1.3-AlI9ORly2zXB5n2ZaDEM2 text-2.0.2
    text-rope-0.3-Dmhgp1oJtpL5EHUV1LaKxV transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    uuid-1.3.16-Fy32w0af5sx1X9unRKjPMO

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

