#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-9xpvmXyEWVLITVwd4GNL5x
key:                  lsp-2.1.0.0-9xpvmXyEWVLITVwd4GNL5x
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  54e7701ecd7ec5f16165334358c66216
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-852rctPylJx60tePrQaSVI:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-852rctPylJx60tePrQaSVI:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-852rctPylJx60tePrQaSVI:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-852rctPylJx60tePrQaSVI:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-9xpvmXyEWVLITVwd4GNL5x
depends:
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    async-2.2.5-HN0qvlEHg8UJWHhrUVAn33
    attoparsec-0.14.4-LQtEgQtiyVz1VW0BNcPBCE base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-3Zn9HlBDJJjKlwH1N49pGH
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko
    lens-5.3.3-JbVUFNwOeNUGLciYleU4If
    lsp-types-2.0.1.0-852rctPylJx60tePrQaSVI mtl-2.2.2
    prettyprinter-1.7.1-158pI0o122BKJZoFMaU38n
    random-1.2.1.3-Lrb8TDGfTan4fST0eiDAa7
    row-types-1.0.1.2-6Mu6hFDXWj4CkwLNgEd6CO
    sorted-list-0.2.3.1-Hv3ouZHPKlCGIUGv5TK6RT stm-2.5.1.0
    temporary-1.3-Jo3GPHqXt7U7op7E9Rmxl4 text-2.0.2
    text-rope-0.3-4Sfo2PrHOJfLeQEowoeX8S transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    uuid-1.3.16-HfbLE3sXZOyDJAY1vuAieO

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

