#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.15.0.1
visibility:           public
id:                   lsp-test-0.15.0.1-8hMShlzosASHeBbnsYmfcL
key:                  lsp-test-0.15.0.1-8hMShlzosASHeBbnsYmfcL
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  6cf2630a902d966d4ce51c0844b548ee
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-2VjITqMTecEFKvXMh9RptU:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-2VjITqMTecEFKvXMh9RptU:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-2VjITqMTecEFKvXMh9RptU:Language.LSP.Protocol.Types,
    Language.LSP.Test

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.15.0.1-8hMShlzosASHeBbnsYmfcL
depends:
    Diff-0.4.1-KJ48I4npTFjHzRWUMxJmhj Glob-0.10.2-6HFwg9HAY2xXoaRcXZBQF
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS
    aeson-pretty-0.8.10-GulstWOdB24FAw6bDCaBa1
    ansi-terminal-1.0.2-tIaEKtcHqOD2jCqJ7RqTi
    async-2.2.5-75FFlJsh5XPALDlYx1XYqh base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-IBB9xtBNbvnLwqzeTgcBM7
    conduit-1.3.6.1-106afLHctvQ8RMVwlIAuXV
    conduit-parse-0.2.1.1-1SvHedWAwVAIAblTO5iEId containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2
    lens-5.3.1-EJGBiJ62DpEHaBgUJVPkQg
    lsp-2.1.0.0-Ftv7hrNHdgW6IKFCFoXoOX
    lsp-types-2.0.1.0-2VjITqMTecEFKvXMh9RptU mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    row-types-1.0.1.2-CapujoOQEDKDAPaDIV3CDS
    some-1.0.6-Kkg1t5LkgxEIMIwPUHQeq1 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

