#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.15.0.1
visibility:           public
id:                   lsp-test-0.15.0.1-IT4e6lDsA6pGhpymZ4s0yb
key:                  lsp-test-0.15.0.1-IT4e6lDsA6pGhpymZ4s0yb
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  38713f67ac86c2a6c98367184437f768
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-47ngMGwTYagAYw5srIxRbF:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-47ngMGwTYagAYw5srIxRbF:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-47ngMGwTYagAYw5srIxRbF:Language.LSP.Protocol.Types,
    Language.LSP.Test

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.15.0.1-IT4e6lDsA6pGhpymZ4s0yb
depends:
    Diff-0.5-5Q1Xtyajup54pAeJMO94Af Glob-0.10.2-E0kjpcZscTAFx3Kotyd0Tl
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7
    aeson-pretty-0.8.10-5fxrLhkA1SsCO3q6H5F8tH
    ansi-terminal-1.0.2-JYusxb73OETHD3sHArHcs
    async-2.2.5-5XB7N1FG9ne5YT8tptoJA4 base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-DnNpatUZ156E7xJjr6d1a
    conduit-1.3.6.1-RIPQH88pa6HdGnxqZVAxX
    conduit-parse-0.2.1.1-EUb95c9hNkcDJTzA8x1CTk containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2
    lens-5.3.2-3x6i1OAeQ2c8gg8RvgTRSW
    lsp-2.1.0.0-KhWBdemCS618YV0Jldc3Cf
    lsp-types-2.0.1.0-47ngMGwTYagAYw5srIxRbF mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    row-types-1.0.1.2-9lunVxNnnuNJ6q3ozFp0qu
    some-1.0.6-CUiJNEIVKo8L6lNar3OAS9 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

