#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lumberjack
version:              1.0.3.0
visibility:           public
id:                   lumberjack-1.0.3.0-DYFhHQEOYnDEYLwkBI7Q0S
key:                  lumberjack-1.0.3.0-DYFhHQEOYnDEYLwkBI7Q0S
license:              ISC
copyright:            2020-2022, Galois Inc.
maintainer:           kquick@galois.com
author:               Kevin Quick
homepage:             https://github.com/GaloisInc/lumberjack
synopsis:             Trek through your code forest and make logs
description:
    This is a logging facility.  Yes, there are many, and this is the one
    with a beard, wearing flannel and boots, that gets the job done.  It'\''s
    not the fanciest, it doesn'\''t have a cargo-van full of features.  This
    logger is designed to be straightforward to use, provide a good set of
    standard features, and be useable across a broad set of code.

    * Logging itself is a monadic activity.  This activity is most often
    performed in a monad stack with a MonadIO context to allow
    writing to files.

    * The specific logging action implementations are managed separately
    from the actions of logging messages in the target code.  This
    allows logging to be configurable and the manner of logging to
    be specified at startup time without requiring changes in the
    code from which log messages are being generated.

    * The logging implementation code can use contravariant functors to
    adjust existing logging.

    * Main code will typically retrieve the logging actions from a Reader
    context in your monad stack.  That said, Log actions are not tied
    to an enclosing Monad.  There are helpers to support a Monad which
    can store Log actions, but Log actions can also be explicitly
    passed and used.

    * The prettyprinter package is used for formatting.

category:             Logging
abi:                  1de981b9acc727d501cb705f6320a0ef
exposed:              True
exposed-modules:      Lumberjack
import-dirs:          /usr/lib/ghc-9.4.8/site-local/lumberjack-1.0.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lumberjack-1.0.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lumberjack-1.0.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lumberjack
hs-libraries:         HSlumberjack-1.0.3.0-DYFhHQEOYnDEYLwkBI7Q0S
depends:
    base-4.17.2.1 contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    exceptions-0.10.5 prettyprinter-1.7.1-H1CnA9YdkYYkwP4aBwQ7e
    prettyprinter-ansi-terminal-1.1.3-5l4bMV180UmCJ9CGBOQJt text-2.0.2
    time-1.12.2

haddock-interfaces:   /usr/share/doc/haskell-lumberjack/html/lumberjack.haddock
haddock-html:         /usr/share/doc/haskell-lumberjack/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

