#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 math-functions
version:              0.3.4.4
visibility:           public
id:                   math-functions-0.3.4.4-FVa3z0DxqghFhUkin99UZQ
key:                  math-functions-0.3.4.4-FVa3z0DxqghFhUkin99UZQ
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  a4b55f70c3d5e4933941699a6b4324cd
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/math-functions-0.3.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-math-functions
hs-libraries:         HSmath-functions-0.3.4.4-FVa3z0DxqghFhUkin99UZQ
depends:
    base-4.17.2.1 data-default-class-0.1.2.1-J2UCuIureY5CbnU1SgrtGb
    deepseq-1.4.8.0 primitive-0.9.1.0-IHF3DoB9Qq2KNGfApZUSXg
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

