#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.1.0
visibility:           public
id:                   mod-0.2.1.0-3eXdWOB68f79ky3mR7iuFN
key:                  mod-0.2.1.0-3eXdWOB68f79ky3mR7iuFN
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  c7389ece83bd562925dff4a8b4c9199c
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.1.0-3eXdWOB68f79ky3mR7iuFN
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-JdV7LeCcNMFKwvi67SGD5e
    semirings-0.7-7tTRZGzN67AF0gaDEa28JG
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

