#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 network
version:              3.1.4.0
visibility:           public
id:                   network-3.1.4.0-1eoJcyQnoY08famP5jSKP3
key:                  network-3.1.4.0-1eoJcyQnoY08famP5jSKP3
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto, Evan Borden
homepage:             https://github.com/haskell/network
synopsis:             Low-level networking interface
description:
    This package provides a low-level networking interface.

    === High-Level Packages
    Other packages provide higher level interfaces:

    * connection
    * hookup
    * network-simple

    === Extended Packages
    @network@ seeks to provide a cross-platform core for networking. As such some
    APIs live in extended libraries. Packages in the @network@ ecosystem are
    often prefixed with @network-@.

    ==== @network-bsd@
    In @network-3.0.0.0@ the @Network.BSD@ module was split off into its own
    package, @network-bsd-3.0.0.0@.

    ==== @network-uri@
    In @network-2.6@ the @Network.URI@ module was split off into its own package,
    @network-uri-2.6@. If you'\''re using the @Network.URI@ module you can
    automatically get it from the right package by adding this to your @.cabal@
    file:

    > library
    >   build-depends: network-uri-flag

category:             Network
abi:                  9d8658113bd55fb5e5f9591104fef9d3
exposed:              True
exposed-modules:
    Network.Socket Network.Socket.Address Network.Socket.ByteString
    Network.Socket.ByteString.Lazy Network.Socket.Internal

hidden-modules:
    Network.Socket.Buffer Network.Socket.ByteString.IO
    Network.Socket.ByteString.Internal Network.Socket.Cbits
    Network.Socket.Fcntl Network.Socket.Flag Network.Socket.Handle
    Network.Socket.If Network.Socket.Imports Network.Socket.Info
    Network.Socket.Name Network.Socket.Options Network.Socket.ReadShow
    Network.Socket.Shutdown Network.Socket.SockAddr
    Network.Socket.Syscall Network.Socket.Types Network.Socket.Unix
    Network.Socket.ByteString.Lazy.Posix Network.Socket.Posix.Cmsg
    Network.Socket.Posix.CmsgHdr Network.Socket.Posix.IOVec
    Network.Socket.Posix.MsgHdr

import-dirs:          /usr/lib/ghc-9.4.8/site-local/network-3.1.4.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/network-3.1.4.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/network-3.1.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-network
hs-libraries:         HSnetwork-3.1.4.0-1eoJcyQnoY08famP5jSKP3
include-dirs:         /usr/lib/ghc-9.4.8/site-local/network-3.1.4.0/include
includes:             HsNet.h HsNetDef.h alignment.h win32defs.h
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 directory-1.3.7.1

haddock-interfaces:   /usr/share/doc/haskell-network/html/network.haddock
haddock-html:         /usr/share/doc/haskell-network/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

