#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 nonce
version:              1.0.7
visibility:           public
id:                   nonce-1.0.7-FCxk9GfVnzOE6CGXzgDTT3
key:                  nonce-1.0.7-FCxk9GfVnzOE6CGXzgDTT3
license:              BSD-3-Clause
copyright:            (c) 2014 Prowdsponsor
maintainer:           Prowdsponsor <opensource@prowdsponsor.com>
author:               Felipe Lessa <felipe.lessa@prowdsponsor.com>
homepage:             https://github.com/prowdsponsor/nonce
synopsis:             Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.

    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.

category:             Cryptography
abi:                  c70c13e393abad53cf181a364efd2784
exposed:              True
exposed-modules:      Crypto.Nonce
import-dirs:          /usr/lib/ghc-9.6.6/site-local/nonce-1.0.7
library-dirs:         /usr/lib/ghc-9.6.6/site-local/nonce-1.0.7
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/nonce-1.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-nonce
hs-libraries:         HSnonce-1.0.7-FCxk9GfVnzOE6CGXzgDTT3
depends:
    base-4.18.2.1 base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t
    bytestring-0.11.5.3 entropy-0.4.1.11-1vtyWzOCursffXS6ZqzcH
    text-2.0.2 transformers-0.6.1.0
    unliftio-0.2.25.1-KPdC22vM2NXFLmIWh7FN8O
    unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY

haddock-interfaces:   /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html:         /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

