#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 optics-core
version:              0.4.1.1
visibility:           public
id:                   optics-core-0.4.1.1-BjQfAVGIIeYEFYsANRhFjd
key:                  optics-core-0.4.1.1-BjQfAVGIIeYEFYsANRhFjd
license:              BSD-3-Clause
maintainer:           optics@well-typed.com
author:               Adam Gundry, Andres Löh, Andrzej Rybczak, Oleg Grenrus
synopsis:             Optics as an abstract interface: core definitions
description:
    This package makes it possible to define and use Lenses, Traversals, Prisms
    and other optics, using an abstract interface.

    This variant provides core definitions with a minimal dependency footprint.
    See the @<https://hackage.haskell.org/package/optics optics>@ package (and its
    dependencies) for documentation and the "batteries-included" variant.

category:             Data, Optics, Lenses
abi:                  3f98b344b0d5250330d9e7f39a90438d
exposed:              True
exposed-modules:
    Data.Either.Optics Data.IntMap.Optics Data.IntSet.Optics
    Data.List.Optics Data.Map.Optics Data.Maybe.Optics
    Data.Sequence.Optics Data.Set.Optics Data.Tree.Optics
    Data.Tuple.Optics Data.Typeable.Optics GHC.Generics.Optics
    Numeric.Optics Optics.AffineFold Optics.AffineTraversal
    Optics.Arrow Optics.At.Core Optics.Coerce Optics.Cons.Core
    Optics.Core Optics.Core.Extras Optics.Each.Core Optics.Empty.Core
    Optics.Fold Optics.Generic Optics.Getter Optics.Indexed.Core
    Optics.Internal.Bi Optics.Internal.Fold Optics.Internal.Generic
    Optics.Internal.Generic.TypeLevel Optics.Internal.Indexed
    Optics.Internal.Indexed.Classes Optics.Internal.IxFold
    Optics.Internal.IxSetter Optics.Internal.IxTraversal
    Optics.Internal.Magic Optics.Internal.Optic
    Optics.Internal.Optic.Subtyping Optics.Internal.Optic.TypeLevel
    Optics.Internal.Optic.Types Optics.Internal.Setter
    Optics.Internal.Traversal Optics.Internal.Utils Optics.Iso
    Optics.IxAffineFold Optics.IxAffineTraversal Optics.IxFold
    Optics.IxGetter Optics.IxLens Optics.IxSetter Optics.IxTraversal
    Optics.Label Optics.Lens Optics.Mapping Optics.Operators
    Optics.Operators.Unsafe Optics.Optic Optics.Prism Optics.Re
    Optics.ReadOnly Optics.ReversedLens Optics.ReversedPrism
    Optics.Review Optics.Setter Optics.Traversal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/optics-core-0.4.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/optics-core-0.4.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/optics-core-0.4.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-optics-core
hs-libraries:         HSoptics-core-0.4.1.1-BjQfAVGIIeYEFYsANRhFjd
depends:
    array-0.5.4.0 base-4.17.2.1 containers-0.6.7
    indexed-profunctors-0.1.1.1-22C7gA3HhCjKgNsu9Fnn18
    indexed-traversable-0.1.4-IdrLHXCvQGN9TboScqmWoy
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-optics-core/html/optics-core.haddock
haddock-html:         /usr/share/doc/haskell-optics-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

