#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.1.12.2
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.1.12.2-8bpAUVXX36a3PmvHtFEPM2-xml-light
key:                  pandoc-3.1.12.2-8bpAUVXX36a3PmvHtFEPM2-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2023 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  b3c6f7d2eb28fff8c77c875e8556b74e
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.12.2-8bpAUVXX36a3PmvHtFEPM2-xml-light
depends:
    base-4.17.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-DXk6R8f2ovN3Ce8tBuBTca
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.1.12.2
visibility:           public
id:                   pandoc-3.1.12.2-6wndHfIA8MPFbfiStYBKim
key:                  pandoc-3.1.12.2-6wndHfIA8MPFbfiStYBKim
license:              GPL-2.0-or-later
copyright:            (c) 2006-2023 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  b695ca5138fe7bd568ace4d427a3c4e3
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Translations Text.Pandoc.Translations.Types
    Text.Pandoc.UTF8 Text.Pandoc.Version Text.Pandoc.Writers
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.TeX
    Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.1.12.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.12.2-6wndHfIA8MPFbfiStYBKim
depends:
    Glob-0.10.2-CY3ooAIMeCxDkxmHqScb8J
    JuicyPixels-3.3.9-KoECyXIKZgJ6ErvKgNpn3A
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-HUj8Ou2Jrr19darX8iyQt4
    aeson-pretty-0.8.10-8ihe1fW3Pbtu3c4hGPQcH array-0.5.4.0
    attoparsec-0.14.4-BuoYNqKkZ0cK5gzfHXNsJW base-4.17.2.1
    base64-bytestring-1.2.1.0-IbCUnYF5PxIJ57HxqijudZ binary-0.8.9.1
    blaze-html-0.9.2.0-9ouvNI0LGvR8T2YDANh957
    blaze-markup-0.8.3.0-H4QAcgAuzx9AWvBQPdzmLl bytestring-0.11.5.3
    case-insensitive-1.2.1.0-JGcld4v8YDLG9iCNMxqnvW
    citeproc-0.8.1.1-BjIpWVJSQ3k6kuhnHLmBea
    commonmark-0.2.6-3UPLqASyLwJ91BvctPefra
    commonmark-extensions-0.2.5.4-B6LIm1EwvmDF95cxReaUKR
    commonmark-pandoc-0.2.2.2-LtA6v8jybiuIxoJ1Kss0xK containers-0.6.7
    crypton-connection-0.4.2-1sGQ83cNjWA9dB88iM5gN1
    crypton-x509-system-1.6.7-BYGW4K0d6luAVwLRN266rS
    data-default-0.7.1.2-8zpNuXeugnsCXhsU9L7wsy deepseq-1.4.8.0
    directory-1.3.7.1 djot-0.1.1.3-Dmimucm4djXKDfCP1wgkUP
    doclayout-0.4.0.1-KYaMITYbK7s2p1JNRSp4HG
    doctemplates-0.11.0.1-CBYVwnXyAZZKDvXEuGq5MZ
    emojis-0.1.4.1-GsPqDvY8sjR97EGs21xpKB exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    gridtables-0.1.0.0-GmYrybotVYW7KDhtOQMGtn
    haddock-library-1.11.0-FetNO4NVPdNGV7nnmHbtsY
    http-client-0.7.18-1ilMUdfjVEzBmOQGNnAaP8
    http-client-tls-0.3.6.4-G572VTUlq1cGiNodxYdpP9
    http-types-0.12.4-22ca4VB3NcX8GYX2Ium30U
    ipynb-0.2-ZH9UcDKEScDOZ9jKUBtwD
    jira-wiki-markup-1.5.1-KsepZIQvunRBzGjV8HS4yX
    mime-types-0.1.2.0-3JrdaebXJwiILES3glDFuq mtl-2.2.2
    network-3.1.4.0-9WwAYDZyp2nAB4XV6sI63l
    network-uri-2.6.4.2-6QHuxl9r30A5vsu5UpWUoB
    pandoc-3.1.12.2-8bpAUVXX36a3PmvHtFEPM2-xml-light
    pandoc-types-1.23.1-8tUmpUaW2l1JGfDyo5a68n parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    process-1.6.18.0 random-1.2.1.3-5GClgMcgHINEWJGyng3KHI
    safe-0.3.21-LwDGcPt9fP72KP4K2XydmJ
    scientific-0.3.8.0-3JrZTDh3ZlGFN4TNaQrQZi
    skylighting-0.14.1.1-6nHyqDrhEHA1LOnQUBj8Ce
    skylighting-core-0.14.1.1-IdmX3GCbqbdCNMyZUVq2h5
    split-0.2.5-B9q8eJqGWtOKQzzX1ITTGf
    syb-0.7.2.4-3WceB4hZfgv1oE6BHeIbtE
    tagsoup-0.14.8-JdUwfABn5woA6kIGg3hD3l
    temporary-1.3-DODaRJ5BM8m1pCh7H7okdb
    texmath-0.12.8.7-9X0u7yz5HAcHywjE7hx7Rf text-2.0.2
    text-conversions-0.3.1.1-DuYjNLZcBz7H9NZXQ7GlDT time-1.12.2
    tls-2.0.6-9jjhxj3NUUiG8pJJDEVF93
    typst-0.5.0.2-Grflu5GUuLMJnPYXyXj3Bp
    unicode-collation-0.1.3.6-39hXhGtzD7Q5c3GZhAqao4
    unicode-transforms-0.4.0.1-2KOhnJAT5sdGBDCkvjUcX4 unix-2.7.3
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    yaml-0.11.11.2-17ksE1qZfJBIhW1Y2VX9Er
    zip-archive-0.4.3.2-4Yjy5u70TDZId6NFRr6bzW
    zlib-0.7.0.0-ClmxrPWTDgrGZgFhkWmoWv

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

