#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.4
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.4-IhAoehLHUZlKv6yut9AXGE-xml-light
key:                  pandoc-3.4-IhAoehLHUZlKv6yut9AXGE-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  0257081e236abe03e7e63ab0315c0151
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-IhAoehLHUZlKv6yut9AXGE-xml-light
depends:
    base-4.17.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-GkCcWqtKyEaLTCbsrDZIQ5
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.4
visibility:           public
id:                   pandoc-3.4-K57FJEmaFQMHvEZvkuscmA
key:                  pandoc-3.4-K57FJEmaFQMHvEZvkuscmA
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  96c540d7c499f8aac8d4d356a5794b66
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.ANSI
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.OpenXML
    Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Docx.Table
    Text.Pandoc.Writers.Docx.Types Text.Pandoc.Writers.GridTable
    Text.Pandoc.Writers.JATS.References Text.Pandoc.Writers.JATS.Table
    Text.Pandoc.Writers.JATS.Types Text.Pandoc.Writers.LaTeX.Caption
    Text.Pandoc.Writers.LaTeX.Notes Text.Pandoc.Writers.LaTeX.Table
    Text.Pandoc.Writers.LaTeX.Lang Text.Pandoc.Writers.LaTeX.Types
    Text.Pandoc.Writers.LaTeX.Citation Text.Pandoc.Writers.LaTeX.Util
    Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Char
    Text.Pandoc.TeX Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-K57FJEmaFQMHvEZvkuscmA
depends:
    Glob-0.10.2-HuOZ1KDUH0g3Y8N4carev1
    JuicyPixels-3.3.9-3NA252MFdZKJWXqNWPnktG
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    aeson-pretty-0.8.10-FoZoq2L63jY6PFOqAzdYHf array-0.5.4.0
    attoparsec-0.14.4-4euoXrooDbuLZe6Xn3rp2d base-4.17.2.1
    base64-bytestring-1.2.1.0-IO7W4nLtABNJGIN4Jp2MEQ binary-0.8.9.1
    blaze-html-0.9.2.0-A6Vi4VW5MkkDRUuOYiyz4t
    blaze-markup-0.8.3.0-4OBPTc45d0P9Dl7KWqlGv6 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4HYxnyEi2mnBK2ectdARDN
    citeproc-0.8.1.1-5XErFEXfF8mAsi8G9PIGKa
    commonmark-0.2.6-6xv89BnMWBu2L7weK4lQ0b
    commonmark-extensions-0.2.5.5-A4lXwAgGmNR2qwxP0nPcRR
    commonmark-pandoc-0.2.2.3-BPmgZ5nVtmRKPaxYYUCnvD containers-0.6.7
    crypton-connection-0.4.5-24gLlm5W8DSBbKnbFL2oNm
    crypton-x509-system-1.6.7-sV6inhhm1eFwogU9y9qsI
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd deepseq-1.4.8.0
    directory-1.3.7.1 djot-0.1.2.2-1ViFiZb5XSW8HmVzdhZxYK
    doclayout-0.5-HKkWOnrFqc91i0cDGkofG2
    doctemplates-0.11.0.1-GDbfmdwl5uUAiz0AoJo20F
    emojis-0.1.4.1-GsPqDvY8sjR97EGs21xpKB exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    gridtables-0.1.1.0-E5vKQM8rLGs7jtWpHAh350
    haddock-library-1.11.0-28GS6rAsBbwH4xklnhcCL8
    http-client-0.7.19-Gua32WeuAi7LtpDxdNLHZk
    http-client-tls-0.3.6.4-Im2XpqDar4e3QdicCLXH1Y
    http-types-0.12.4-5kbj0Cv0rp8HNRwQfelhRA
    ipynb-0.2-Hupmbo1Equ6HtN1QdLuAGE
    jira-wiki-markup-1.5.1-E5atmdpoKvBgnlLtOGOmQ
    mime-types-0.1.2.0-3JrdaebXJwiILES3glDFuq mtl-2.2.2
    network-3.1.4.0-7fNpNYdJiSEL43akp61gqU
    network-uri-2.6.4.2-FfZCDPDUWea9JZl5JGUmKF
    pandoc-3.4-IhAoehLHUZlKv6yut9AXGE-xml-light
    pandoc-types-1.23.1-10ERTHkIQl98bdxKqE9Rpy parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-Dwgsrh12Px3tJNgclFhNg
    process-1.6.18.0 random-1.2.1.3-8ADb21VvJl3AtsgmJLZ0Jg
    safe-0.3.21-h7eXfPvXuk1aMCYRfiuDr
    scientific-0.3.8.0-GtjUIC3j80u95XeMq22yYk
    skylighting-0.14.3-306TpIxSaKHy6X5rhsKXb
    skylighting-core-0.14.3-7HXhfi1Ud6hH0vzmtWkp5F
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-Dk2TUQSTxWd5yTqOEWpD7k
    tagsoup-0.14.8-2IXVCK7wAML5lleGSzoKmr
    temporary-1.3-AlI9ORly2zXB5n2ZaDEM2
    texmath-0.12.8.10-86ZL3CJJ7IrFYNMQ3SPhn2 text-2.0.2
    text-conversions-0.3.1.1-4zmGVBbl2LtLhvl7QchTPs time-1.12.2
    tls-2.0.6-AkNFoKWmlTI7j1zmNKZeT6 typst-0.6-HGUtXpqkZy36naOwzCWqMh
    unicode-collation-0.1.3.6-8zyh62b3rTh3PS76lonNDG
    unicode-transforms-0.4.0.1-I3jl2Pzo34XAuKCYNMygDE unix-2.7.3
    vector-0.13.2.0-9W9rHKyBrY08EKASla5WO0
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    yaml-0.11.11.2-A24Vc8AbuOD79YcMIVAzYx
    zip-archive-0.4.3.2-3eDUBom8ZFMDcDjeQaVwS5
    zlib-0.7.0.0-CWCQOp9WY8aARLfbxZwOd5

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

