#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc-lua-marshal
version:              0.2.7.1
visibility:           public
id:                   pandoc-lua-marshal-0.2.7.1-EFKEl4krZ9U1oasTaHB1Is
key:                  pandoc-lua-marshal-0.2.7.1-EFKEl4krZ9U1oasTaHB1Is
license:              MIT
copyright:            © 2017-2024 Albert Krewinkel, John MacFarlane
maintainer:           Albert Krewinkel <albert@zeitkraut.de>
author:               Albert Krewinkel, John MacFarlane
homepage:             https://github.com/pandoc/pandoc-lua-marshal
synopsis:             Use pandoc types in Lua
description:
    This package provides functions to marshal and unmarshal
    pandoc document types to and from Lua.

    The values of most types are pushed to pandoc as "userdata"
    objects that wrap a stable pointer to the Haskell value;
    these objects come with methods to access and modify their
    properties.

    Sequences are pushed as normal Lua tables, but are
    augmented with convenience functions.

category:             Foreign
abi:                  88afce3b132c92ff93f6e30ad4da46e5
exposed:              True
exposed-modules:
    Text.Pandoc.Lua.Marshal.AST Text.Pandoc.Lua.Marshal.Alignment
    Text.Pandoc.Lua.Marshal.Attr Text.Pandoc.Lua.Marshal.Block
    Text.Pandoc.Lua.Marshal.Cell Text.Pandoc.Lua.Marshal.Citation
    Text.Pandoc.Lua.Marshal.CitationMode
    Text.Pandoc.Lua.Marshal.Content Text.Pandoc.Lua.Marshal.Filter
    Text.Pandoc.Lua.Marshal.Format Text.Pandoc.Lua.Marshal.Inline
    Text.Pandoc.Lua.Marshal.List Text.Pandoc.Lua.Marshal.ListAttributes
    Text.Pandoc.Lua.Marshal.MathType Text.Pandoc.Lua.Marshal.MetaValue
    Text.Pandoc.Lua.Marshal.Pandoc Text.Pandoc.Lua.Marshal.QuoteType
    Text.Pandoc.Lua.Marshal.Row Text.Pandoc.Lua.Marshal.SimpleTable
    Text.Pandoc.Lua.Marshal.TableFoot Text.Pandoc.Lua.Marshal.TableHead
    Text.Pandoc.Lua.Marshal.TableParts

hidden-modules:
    Text.Pandoc.Lua.Marshal.Shared Text.Pandoc.Lua.Topdown
    Text.Pandoc.Lua.SpliceList Text.Pandoc.Lua.Walk

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-lua-marshal-0.2.7.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-lua-marshal-0.2.7.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-lua-marshal-0.2.7.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc-lua-marshal
hs-libraries:         HSpandoc-lua-marshal-0.2.7.1-EFKEl4krZ9U1oasTaHB1Is
depends:
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7 exceptions-0.10.5
    hslua-2.3.0-KYbk8LTG4lhGPpzxy3nVeV
    hslua-list-1.1.3-61aScYsuub1B8ubfaTCKQO
    hslua-marshalling-2.3.1-JwvRQcwn4p8ImJNLtPPu60
    pandoc-types-1.23.1-8ey3S1zLWYZ6MpBkNqPsfN
    safe-0.3.21-BDeWrSgar9b2azUh8fJqoI text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-pandoc-lua-marshal/html/pandoc-lua-marshal.haddock

haddock-html:         /usr/share/doc/haskell-pandoc-lua-marshal/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

