#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 parameterized-utils
version:              2.1.10.0
visibility:           public
id:                   parameterized-utils-2.1.10.0-9xKkVD3l97l71L8eAJUNSw
key:                  parameterized-utils-2.1.10.0-9xKkVD3l97l71L8eAJUNSw
license:              BSD-3-Clause
copyright:            ©2016-2022 Galois, Inc.
maintainer:           kquick@galois.com, rscott@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  cfcb7ab438b8c38e0c1935ad67e2bf10
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All Data.Parameterized.Axiom
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.Fin
    Data.Parameterized.FinMap Data.Parameterized.FinMap.Safe
    Data.Parameterized.FinMap.Unsafe Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.TraversableFC.WithIndex
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-parameterized-utils
hs-libraries:         HSparameterized-utils-2.1.10.0-9xKkVD3l97l71L8eAJUNSw
depends:
    base-4.17.2.1 base-orphans-0.9.3-L4rR6vpXmRoHjml8xYoLP7
    constraints-0.14.1-4UjFQgdm2TbFFKFu6B9cSa containers-0.6.7
    deepseq-1.4.8.0 ghc-prim-0.9.1
    hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2
    hashtables-1.4.1-GFyVo7y3D3A2H8KKO710d2
    indexed-traversable-0.1.4-C3JpN7YDWmy6ZJ7hWVfhAu
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB mtl-2.2.2
    profunctors-5.6.3-CZGRj4axmFA9bHsS9eciFX template-haskell-2.19.0.0
    text-2.0.2 th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

