#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-ARgLJD5U2DTB9k49fuDvzT
key:                  pipes-safe-2.3.5-ARgLJD5U2DTB9k49fuDvzT
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  786132b8bb919be8c2503b3d60ed8bc0
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-ARgLJD5U2DTB9k49fuDvzT
depends:
    base-4.17.2.1 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-8hRw9mjLBLl6PAQlNWysTu mtl-2.2.2
    pipes-4.3.16-E6VhsavkawxCFhVnwERRTJ
    primitive-0.9.1.0-ICFc9Oc8RCqLS4oNEzcX43 transformers-0.5.6.2
    transformers-base-0.4.6-9k6sqnTM6dd156kd3yeDl4

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

