#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-5s5mq2rZ2AnGc53u6ZufOF
key:                  pipes-safe-2.3.5-5s5mq2rZ2AnGc53u6ZufOF
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  01e7cc8cbcc94f1ec7c84a7d6b0ab6a5
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.6.6/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-5s5mq2rZ2AnGc53u6ZufOF
depends:
    base-4.18.2.1 containers-0.6.7 exceptions-0.10.7
    monad-control-1.0.3.1-6BZrEcXVVy1ERiltg4JMsJ mtl-2.3.1
    pipes-4.3.16-CWjFwBVcKQ0Lk4J7E7HAO5
    primitive-0.9.1.0-5oPemL25pV0IilCVm0ELcB transformers-0.6.1.0
    transformers-base-0.4.6-LskmwIYyClP9hZC0NTtvHv

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

