#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-G224rUxcsOZ2qySAkB8Eoh
key:                  postgresql-binary-0.12.5-G224rUxcsOZ2qySAkB8Eoh
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  4a1b4bf25afde950d70b73a12f73b731
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-G224rUxcsOZ2qySAkB8Eoh
depends:
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp base-4.17.2.1
    binary-parser-0.5.7.7-4gmnTq52YTYEMxIG5EmqtB bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-FQ9pnHWLEJj8sXOeyIgZVz
    containers-0.6.7 network-ip-0.3.0.3-8P04V1ndg0Z2AkuMkhv58Y
    scientific-0.3.8.0-hGLqISimekA59HuDEk96u text-2.0.2 time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    uuid-1.3.16-Jc2WSMIN71EG9lK7bB1JO4
    vector-0.13.2.0-2If6MrCrP3g55Bnhb5dowG

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

