#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-73Ilf0yXAf55YslgUnrd52
key:                  postgresql-binary-0.12.5-73Ilf0yXAf55YslgUnrd52
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  ee868f1f0dd4b003845c256694ca9043
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-73Ilf0yXAf55YslgUnrd52
depends:
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31 base-4.17.2.1
    binary-parser-0.5.7.7-2VqSDcRd7GKIqfJCraB1CO bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-Gt0vF7z8nOIjAFRa1C4wD
    containers-0.6.7 network-ip-0.3.0.3-21Q4syIqmRd7DJvuHbBgw1
    scientific-0.3.8.0-75VbuY3tmfA8QFAgCCeEHk text-2.0.2 time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    uuid-1.3.16-EhXidLed9gM6Z7XoSBy8d6
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

